/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.container;

import com.google.common.annotations.VisibleForTesting;
import dev.toma.gunsrpg.common.container.AbstractContainer;
import dev.toma.gunsrpg.common.item.StorageItem;
import dev.toma.gunsrpg.util.math.IDimensions;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;

public abstract class GenericStorageContainer
extends AbstractContainer {
    private final ItemStack stack;
    private final IInventory inventory;
    private final int slotCount;

    public GenericStorageContainer(ContainerType<? extends GenericStorageContainer> type, PlayerInventory inventory, int windowId) {
        super(type, windowId);
        this.stack = inventory.field_70458_d.func_184614_ca();
        StorageItem item = (StorageItem)this.stack.func_77973_b();
        StorageItem.IInputFilter filter = item.getInputFilter();
        IDimensions dimensions = item.getDimensions();
        this.inventory = item.getInventory(this.stack, this::onChangedCallback);
        int left = 8;
        int top = 18;
        int width = dimensions.getWidth();
        int height = dimensions.getHeight();
        this.slotCount = width * height;
        double offset = GenericStorageContainer.getOffsetModifier(width);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int xPosition = GenericStorageContainer.getOffset(x, offset);
                this.func_75146_a(new RestrictedSlot(this.inventory, filter, y * width + x, left + xPosition, top + y * 18));
            }
        }
        this.addPlayerInventory(inventory, height * 18 + 38);
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.onChangedCallback(this.inventory);
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = this.func_75139_a(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            stack = slotStack.func_77946_l();
            if (index < this.slotCount ? !this.func_75135_a(slotStack, this.slotCount, this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, this.slotCount, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return stack;
    }

    public boolean func_75145_c(PlayerEntity player) {
        return player.func_70089_S() && this.stack == player.func_184614_ca();
    }

    private void onChangedCallback(IInventory inventory) {
        if (inventory != null) {
            StorageItem.saveInventoryContents(this.stack, inventory);
        }
    }

    @VisibleForTesting
    static double getOffsetModifier(int width) {
        return (double)(9 - width) * 0.5;
    }

    @VisibleForTesting
    static int getOffset(int x, double modifier) {
        double left = modifier * 18.0;
        return (int)(left + (double)(x * 18));
    }

    public static class SavingInventory
    extends Inventory {
        private final StorageItem.InventorySaveCallback callback;

        public SavingInventory(int size, StorageItem.InventorySaveCallback callback) {
            super(size);
            this.callback = callback;
        }

        public void func_70296_d() {
            super.func_70296_d();
            this.callback.onSave((IInventory)this);
        }
    }

    public static class RestrictedSlot
    extends Slot {
        final StorageItem.IInputFilter filter;

        public RestrictedSlot(IInventory inventory, StorageItem.IInputFilter filter, int id, int x, int y) {
            super(inventory, id, x, y);
            this.filter = filter;
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return this.filter.isValidInput(stack);
        }
    }
}

